<?php

namespace App\Models;

use App\Enums\ProductStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded=['id'];
    public function product()
    {
        return $this->hasMany(Product::class,'category_id','id')->where('status',ProductStatus::ACTIVE)->whereHas('variety')->with('variety','extra','material');
    }
    public function productMenu()
    {
        return $this->hasMany(Product::class,'menu_id','id')->where('status',ProductStatus::ACTIVE)
            ->whereHas('variety')->with('varieties','extra','material');
    }
    public function children()
    {
        return $this->hasMany(self::class, 'parent_id');
    }

}
