<?php

namespace App\Models;

use App\Repositories\Branch\BranchRepository;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class Comment extends Model
{
    use HasFactory;

    protected $guarded = ['id'];
    protected $casts = [
        'products' => 'json',
        'admin_approve' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function child()
    {
        return $this->hasMany(Comment::class, 'parent_id', 'id');
    }

        public function getProductsAttribute($value)
    {
        // اگر $value رشته JSON است، آن را decode کن
        if (is_string($value)) {
            $decoded = json_decode($value, true);
            return $decoded ?? [];
        }

        // اگر $value آرایه است، آن را برگردان
        if (is_array($value)) {
            return $value;
        }

        // اگر $value null یا هر چیز دیگری است، آرایه خالی برگردان
        return [];
    }
}

