<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Component extends Model
{
    use HasFactory;

    protected $guarded = ['id'];
    protected $casts = ['filter'=>'array', 'extra'=>'array'];

    public function getFilterAttribute($value)
    {

        if ($value != null) {
            return json_decode($value, true);
        }
        return null;
    }

    public function getExtraAttribute($value)
    {

        if ($value != null) {
            return json_decode($value, true);
        }
        return null;
    }
}

