<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Courier\app\Models\BranchCourier;

class Order extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = ['id'];
    use SoftDeletes;

    public function getCartsAttribute($value)
    {
        if ($value != null)
            return json_decode($value, true);
        else
            return null;
    }

    public function orderCart()
    {
        return $this->hasMany(OrderCart::class, 'order_id', 'id')->with('variety');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    
    public function driver()
    {
        return $this->belongsTo(BranchCourier::class, 'driver_id', 'user_id')->with('user');
    }

    public function customer()
    {
        return $this->belongsTo(CustomerBranch::class, 'user_id', 'user_id')->with('user');
    }


    public function commentUser()
    {
        return $this->belongsTo(Comment::class, 'id', 'order_id');
    }


    public function address_order()
    {
        return $this->belongsTo(Address::class, 'address_id', 'id');
    }

    public function deliveryType()
    {
        return $this->belongsTo(DeliveryType::class, 'delivery_type_id', 'id');
    }

    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->setTimezone('Asia/Tehran')->format('Y-m-d H:i:s');
    }

    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->setTimezone('Asia/Tehran')->format('Y-m-d H:i:s');
    }

}
