<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\DB;

class OrderCart extends Model
{
    use HasFactory;
    protected $guarded=['id'];
    public function extras(): BelongsToMany
    {
        return $this->belongsToMany(Extra::class, 'order_cart_extra', 'order_cart_id', 'extra_id');
    }

    public function variety()
    {
        return $this->belongsTo(Variety::class, 'variety_id', 'id')->select('*',
            DB::raw('(price - (price * discount / 100)) as discounted_price'))->with('product:id,title,image,description');
    }

}
