<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Morilog\Jalali\Jalalian;

class PopupAlarmView extends Model
{
    use HasFactory;

    protected $fillable = [
        'popup_alarm_id',
        'user_id',
        'viewed_at'
    ];

    protected $casts = [
        'viewed_at' => 'datetime',
    ];

    /**
     * رابطه با آلارم
     */
    public function popupAlarm(): BelongsTo
    {
        return $this->belongsTo(PopupAlarm::class);
    }

    /**
     * رابطه با کاربر
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * دریافت تاریخ شمسی مشاهده
     */
    public function getViewedAtJalaliAttribute(): string
    {
        return Jalalian::fromCarbon($this->viewed_at)->format('Y/m/d H:i');
    }
}
