<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PrinterDevice extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name','slug','type','purpose','branch_id',
        'host','port','queue','qz_name','printnode_printer_id',
        'template_key','paper_width_mm','dpi','escpos_profile','capabilities',
        'item_filters','order_filters','enabled_time_windows',
        'max_retries','backoff_seconds','allowlist_ips',
        'location','last_seen_at','last_job_at','last_error_at','last_error',
        'is_active','is_default','priority',
    ];

    protected $casts = [
        'is_active'            => 'boolean',
        'is_default'           => 'boolean',
        'priority'             => 'integer',
        'paper_width_mm'       => 'integer',
        'dpi'                  => 'integer',
        'port'                 => 'integer',
        'max_retries'          => 'integer',
        'backoff_seconds'      => 'integer',
        'capabilities'         => 'array',
        'item_filters'         => 'array',
        'order_filters'        => 'array',
        'enabled_time_windows' => 'array',
        'allowlist_ips'        => 'array',
        'last_seen_at'         => 'datetime',
        'last_job_at'          => 'datetime',
        'last_error_at'        => 'datetime',
    ];

    public function printJobs(): HasMany
    {
        return $this->hasMany(PrintJob::class);
    }

    
    public function branch(): BelongsTo { return $this->belongsTo(Branch::class); }

    public function scopeActive($q) { return $q->where('is_active', true); }
    
    public function scopePurpose($q, string $purpose) { return $q->where('purpose', $purpose); }
    
    public function scopeOfType($q, string $type) { return $q->where('type', $type); }
    
    public function scopeForStore($q, $storeId) {
        return $q->where(function($qq) use ($storeId) {
            $qq->whereNull('store_id')->orWhere('store_id', $storeId);
        });
    }
}
