<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Product extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = ['id'];

    public function variety()
    {
        return $this->belongsTo(Variety::class, 'id', 'product_id')->select('*',
            DB::raw('(price - (price * discount / 100)) as discounted_price'));
    }

    public function getImagesAttribute($value)
    {
        if ($value != null)
            return json_decode($value);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id')->with('vendor:title');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function extra()
    {
        return $this->belongsToMany(Extra::class, 'product_extras')->with('extraType');
    }

    public function varieties()
    {
        return $this->hasMany(Variety::class)->select(
            ['id', 'product_id', 'title', 'price', 'price_paking', 'count', 'discount', 'order', 'max_order',
                DB::raw('(price - (price * discount / 100)) as discounted_price')]
        );
    }

    public function material()
    {
        return $this->belongsToMany(Material::class, 'product_materials')->withPivot('usage_per_unit')->with('unit');
    }

    public function files(): MorphMany
    {
        return $this->morphMany(File::class, 'filable');
    }

}

