<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = ['id'];
    public function category()
    {
        return $this->belongsTo(TicketCategory::class, 'category_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function child()
    {
        return $this->hasMany(Ticket::class, 'parent_id', 'id')->with('user:id,name,family');
    }
}
