<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable;
    Use SoftDeletes;

    protected $guarded=['id'];


    public function address()
    {
        return $this->hasMany(Address::class,'user_id','id');
    }
    public function defaultAddress()
    {
        return $this->hasOne(Address::class,'id','default_address_id');
    }
    public function branch()
    {
        return $this->hasOne(Branch::class,'id','target_role_id');
    }
    public function transactions()
    {
        return $this->hasMany(Transaction::class,'user_id','id');
    }

    /**
     * Get the customer branches for this user.
     */
    public function customerBranches()
    {
        return $this->hasMany(CustomerBranch::class);
    }
}
