<?php

namespace App\Repositories\Address;

use App\Models\ActiveTime;
use App\Models\Address;
use App\Models\Area;
use App\Models\User;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Morilog\Jalali\Jalalian;

abstract class  EloquentRepository extends BaseRepository
{
    public function __construct(Address $model)
    {
        parent::__construct($model);
    }


    public function getAddressUser($request)
    {
        $user = auth()->user();
        if (!$user) {
            return collect();
        }
        if(isset($request['isAdmin']) and $request['isAdmin']==true and ($user['role_id'] == 1 || $user['role_id'] == 6|| $user['role_id'] ==3)){
            $query = Address::where('user_id', $request['user_id']);
        }else{
            $query = Address::where('user_id', $user->id);
        }
        if(isset($request['address_title'])){
            $query->where('title', 'like', '%'.$request['address_title'].'%');
        }
        if(isset($request['address_area'])){
            $area = Area::find($request['address_area']);
            if ($area) {
                $query->where('area_id', $area->parent_id);
            }
        }
        return $query->get();
    }

    public function checkAddress($date, $branchId)
    {
        try {
            $dateCarbon = Jalalian::fromFormat('Y/m/d H:i:s', $date)->toCarbon();
            $dayName = $dateCarbon->format('l');
            $nowTime = $dateCarbon->format('H:i:s');

            $activeTime = ActiveTime::where('branch_id', $branchId)
                ->where('week_day', $dayName)
                ->where('from_time', '<=', $nowTime)
                ->where('to_time', '>=', $nowTime)->first();


            if ($activeTime == null)
                return ['status' => 400, 'message' => 'امکان ارسال در این زمان نیست', 'data' => null];

            return ['data' => $activeTime, 'status' => 200, 'message' => 'امکان ثبت سفارش در زمان وارد شده مبیاشد'];

        } catch (\Exception $e) {
            return ['status' => 500, 'message' => $e->getMessage(), 'data' => null];
        }
    }
}

