<?php

namespace App\Repositories\Agent;


use App\Models\Agent;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\ExportImport\ExportImportRepository;
use Illuminate\Support\Facades\Log;

abstract class  EloquentRepository extends BaseRepository
{

    public function __construct(Agent $model)
    {
        parent::__construct($model);
    }


    public function getWithFilter(array $filter = [])
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('name', 'like', '%' . $filter['search'] . '%')->orWhere('family', 'like', '%' . $filter['search']);
                }
            })->where(function ($q) use ($filter) {
                if (isset($filter['mobile']) && !empty($filter['mobile'])) {
                    $q->where('mobile', $filter['mobile']);
                }
            })->where(function ($q) use ($filter) {
                if (isset($filter['area_id']) && !empty($filter['area_id'])) {
                    $q->where('area_id', $filter['area_id']);
                }
            });
            if (isset($filter['export']) and $filter['export'] == true) {
                $export = clone $data;
                app(ExportImportRepository::class)->createExcelFileUsers($export->get()->toArray());
            }
            if (isset($filter['paginate']) and $filter['paginate'])
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }


}
