<?php

namespace App\Repositories\Area;

use App\Models\Area;
use App\Models\Branch;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\Branch\BranchRepository;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Area $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [])
    {
        Log::info($filter);
        try {
            $areas = $this->model->where(function ($q) use ($filter) {
                    if (isset($filter['search']) && !empty($filter['search'])) {
                        $q->where('title', 'like', '%' . $filter['search'] . '%');
                    }
                    if (!isset($filter['type']) || $filter['type']!='all' ){
                        if (isset($filter['parent_id']) && !empty($filter['parent_id'])) {
                            $q->where('parent_id', $filter['parent_id']);
                        }else{
                            $q->where('parent_id',0);
                        }
                    }
                    if (isset($filter['coordinates']) && $filter['coordinates'] == 1) {
                        $q->whereNotNull('coordinates');
                    }
            })->get();

            // Add has_management flag if branch_id is provided
            if (isset($filter['branch_id']) && !empty($filter['branch_id'])) {
                $areas->each(function ($area) use ($filter) {
                    $area->has_management = $area->hasManagementForBranch($filter['branch_id']);
                });
            }

            return $areas;
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function getWithParentId($parentId)
    {
        return $this->model->where('parent_id', $parentId)->get();
    }


    public function getAreaWithPoint($lng, $lat) {
        return Area::query()
        ->whereNotNull('lat')->whereNotNull('lng')
        ->selectRaw('(
            6371 * acos(
                cos(radians(?)) * cos(radians(lat)) * cos(radians(lng) - radians(?)) +
                sin(radians(?)) * sin(radians(lat))
            )
        ) AS distance_km', [$lat, $lng, $lat])
        ->orderBy('distance_km')
        ->first();
    }





}
