<?php

namespace App\Repositories\AreaSpecialCondition;

use App\Repositories\BaseRepository\Interface\BaseRepositoryInterface;

interface RepositoryInterface extends BaseRepositoryInterface
{
    /**
     * Get all special conditions with optional filters
     */
    public function getWithFilter(array $filters = [], bool $paginate = false);

    /**
     * Get special conditions for a specific branch
     */
    public function getByBranch($branchId, array $filters = []);

    /**
     * Get special conditions for a specific area
     */
    public function getByArea($areaId, array $filters = []);

    /**
     * Get special conditions for a specific date
     */
    public function getByDate($date, array $filters = []);

    /**
     * Get active special conditions within time range
     */
    public function getActiveWithinTimeRange($startTime, $endTime, array $filters = []);

    /**
     * Check if there are conflicting conditions for the same branch, area, date and time
     */
    public function hasConflictingConditions($branchId, $areaId, $date, $startTime, $endTime, $excludeId = null);

    /**
     * Get special conditions that are currently active
     */
    public function getCurrentlyActive(array $filters = []);
}
