<?php

namespace App\Repositories\BankAccount;

use App\Models\BankAccount;

class BankAccountRepository extends EloquentRepository
{
    public function model()
    {
        return BankAccount::class;
    }

    public function store(array $data)
    {
        if (isset($data['is_active']) && $data['is_active'] == 1) {
            $this->model->where('user_id', auth()->id())->update(['is_active' => 0]);
        }
        return parent::store($data);
    }

    // Admin methods
    public function storeByAdmin(array $data)
    {
        $userId = $data['user_id'];
        if (isset($data['is_active']) && $data['is_active'] == 1) {
            $this->model->where('user_id', $userId)->update(['is_active' => 0]);
        }
        $data['user_id'] = $userId;
        return $this->model->create($data);
    }

    public function updateByAdmin($id, array $attributes)
    {
        try {
            $find = $this->model->find($id);
            if ($find) {
                if (isset($attributes['is_active']) && $attributes['is_active'] == 1) {
                    $this->model->where('user_id', $find->user_id)->update(['is_active' => 0]);
                }
                $find->delete();
                $attributes['before_id'] = $id;
                $attributes['user_id'] = $find->user_id;
                return $this->model->create($attributes);
            } else
                return null;
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
            return null;
        }
    }

    public function destroyByAdmin($id)
    {
        try {
            $find = $this->model->find($id);
            if ($find) {
                $find->delete();
                return true;
            } else
                return null;
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
            return null;
        }
    }

    public function findById($id)
    {
        return $this->model->find($id);
    }

    /**
     * Toggle is_active status for bank account
     * If activating, deactivate all other accounts for the same user
     */
    public function toggleStatus($id)
    {
        try {
            $bankAccount = $this->model->find($id);
            if (!$bankAccount) {
                return null;
            }

            $newStatus = !$bankAccount->is_active;

            // If activating this account, deactivate all other accounts for the same user
            if ($newStatus == 1) {
                $this->model->where('user_id', $bankAccount->user_id)
                    ->where('id', '!=', $id)
                    ->update(['is_active' => 0]);
            }

            $bankAccount->is_active = $newStatus;
            $bankAccount->save();

            return $bankAccount;
        } catch (\Exception $e) {
            \Log::error('Toggle bank account status error: ' . $e->getMessage());
            return null;
        }
    }
}
