<?php

namespace App\Repositories\BankAccount;

use App\Models\BankAccount;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(BankAccount $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['user_id']) && !empty($filter['user_id'])) {
                    $q->where('user_id', $filter['user_id']);
                }
            })->orderBy('id', 'DESC');
            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            return null;
        }
    }

    public function getByUser(array $filter = [], $paginate = true)
    {
        try {
            $data = $this->model->where('user_id', auth()->id())->orderBy('id', 'DESC');
            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            return null;
        }
    }


    public function showC($id)
    {
        return $this->model->where('user_id', auth()->id())->where('id', $id)->first();
    }

    public function updateC($id, array $attributes)
    {
        try {
            $find = $this->showC($id);
            if ($find) {
                $find->delete();
                $attributes['before_id'] = $id;
                $attributes['user_id'] = auth()->id();
                return $this->store($attributes);
            } else
                return null;
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function destroyC($id)
    {
        try {
            $find = $this->showC($id);
            if ($find) {
                $find->delete();
                return true;
            } else
                return null;
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }
}
