<?php

namespace App\Repositories\BaseRepository;

use App\Repositories\BaseRepository\Interface\BaseRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Log;

abstract class BaseRepository implements BaseRepositoryInterface
{
    protected Model $model;

    public function __construct(Model $model)
    {
        $this->model = $model;
    }

    public function store(array $data)
    {
        $user = auth()->user();
        try {
            if(isset($user['role_id']) and  $user['role_id'] != 1 && !isset($data['user_id'])){
                $data['user_id'] = auth()->id();
            }
            return $this->model->create($data);
        } catch (QueryException $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function get(array $filter = [])
    {
        try {
            return $this->model->where($filter)->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }


    public function update($id, array $attributes)
    {
        try {
            $find = $this->model->find($id);
            Log::info($id);
            if ($find)
                return $find->update($attributes);
            else
                return null;
        } catch (\Exception $e) {
            Log::info($e);
            return null;
        }
    }

    public function destroy($id)
    {
        try {
            $find = $this->model->find($id);
            if ($find)
                return $this->model->find($id)->delete();
            else
                return null;
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function show($id, $filter = [], $with = null, $select = null)
    {
        try {
            $query = $this->model->where('id', $id);
            foreach ($filter as $column => $value) {
                $query->where($column, $value);
            }
            if ($with != null) $query->with($with);

            if ($select != null) $query->select($select);

            return $query->first();

        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }
}
