<?php

namespace App\Repositories\BranchHoliday;

interface RepositoryInterface
{
    public function createHoliday(array $data);
    public function updateHoliday($id, array $data);
    public function deleteHoliday($id);
    public function getBranchHolidays($filters = [], $branchId);
    public function checkHoliday($date, $time = null, $branchId);
    public function getActiveHolidaysInRange($startDate, $endDate, $branchId);
    public function getUpcomingHolidays($limit = 10, $branchId);
    public function isBranchOpen($date = null, $time = null, $branchId);
}
