<?php

namespace App\Repositories\Component;

use App\Models\Component;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\Component\ComponentType\Banner\DoubleBanner;
use App\Repositories\Component\ComponentType\Banner\FiveBanner;
use App\Repositories\Component\ComponentType\Banner\FourthBanner;
use App\Repositories\Component\ComponentType\Banner\SingleBanner;
use App\Repositories\Component\ComponentType\Banner\SixBanner;
use App\Repositories\Component\ComponentType\Banner\TripleBanner;
use App\Repositories\Component\ComponentType\ComponentTypeInterface;
use App\Repositories\Component\ComponentType\Discount\DiscountProductType1;
use App\Repositories\Component\ComponentType\Discount\DiscountProductType2;
use App\Repositories\Component\ComponentType\Category\CategoryMain;
use App\Repositories\Component\ComponentType\Product\ProductSliderType1;
use App\Repositories\Component\ComponentType\Product\ProductSliderType2;
use App\Repositories\Component\ComponentType\Product\ProductSliderType3;
use App\Repositories\Component\ComponentType\Register\RegisterSeller1;
use App\Repositories\Component\ComponentType\seller\SellerSliderType1;
use App\Repositories\Component\ComponentType\Slider\DoubleSlider;
use App\Repositories\Component\ComponentType\Slider\FiveSlider;
use App\Repositories\Component\ComponentType\Slider\FourthSlider;
use App\Repositories\Component\ComponentType\Slider\SingleSlider;
use App\Repositories\Component\ComponentType\Slider\SixSlider;
use App\Repositories\Component\ComponentType\Slider\TripleSlider;

class ComponentRepository extends BaseRepository implements RepositoryInterface
{
    public function __construct(Component $model)
    {
        parent::__construct($model);
    }


    public function getRepository($type): ComponentTypeInterface
    {
        $repositoryClass = $this->repositories[$type];
        return new $repositoryClass;
    }

    public function getFront($code, $request = null)
    {
        $record = Component::where('code', $code)->first();
        if ($record == null)
            return [];
        return $this->getRepository($record->name_component)->getFront($record, $request);
    }

    public function storeCustom($data)
    {
        if (!isset($data['type']))
            return ['data' => [], 'status' => 400, 'message' => 'اطلاعات ارسال شده اشتباه اس '];
        return $this->getRepository($data['type'])->store($data);
    }

    protected $repositories = [
        'DiscountProductType1' => DiscountProductType1::class,
        'DiscountProductType2' => DiscountProductType2::class,

        'ProductSliderType1' => ProductSliderType1::class,
        'ProductSliderType2' => ProductSliderType2::class,
        'ProductSliderType3' => ProductSliderType3::class,


        'SingleSlider' => SingleSlider::class,
        'DoubleSlider' => DoubleSlider::class,
        'TripleSlider' => TripleSlider::class,
        'FourthSlider' => FourthSlider::class,
        'FiveSlider' => FiveSlider::class,
        'SixSlider' => SixSlider::class,


        'SingleBanner' => SingleBanner::class,
        'DoubleBanner' => DoubleBanner::class,
        'TripleBanner' => TripleBanner::class,
        'FourthBanner' => FourthBanner::class,
        'FiveBanner' => FiveBanner::class,
        'SixBanner' => SixBanner::class,

        'SellerSliderType1' => SellerSliderType1::class,


        'RegisterSeller1' => RegisterSeller1::class,
        'CategoryMain' => CategoryMain::class,
        'Header1',
        'Header2',
        'Footer1',
        'Category1',
        'SellersWithFilter',
        'ProductWithSidebar',
    ];

    public function getListComponentWithSlug($slug, $type)
    {
        return $this->model->when($slug !== null, function ($query) use ($slug) {
            $query->where('slug', $slug);
        }, function ($query) {
            $query->whereNull('slug');
        })->where('type', $type)->orderBy('order', 'desc')->select('id', 'name_component', 'slug', 'code', 'filter', 'extra', 'is_request', 'type')->get();
    }

    public function getFilterAndExtraInput($type)
    {
        return $this->getRepository($type)->filterAndExtraInput();
    }


    public function list($slug, $type, $data)
    {
        return $this->model->when($slug !== null, function ($query) use ($slug) {
            $query->where('slug', $slug);
        }, function ($query) {
            $query->whereNull('slug');
        })->where('type', $type)->orderBy('order', 'desc')->select('id', 'name_component', 'slug', 'code', 'filter', 'extra', 'is_request', 'type', 'order')->get();

    }
}
