<?php

namespace App\Repositories\Component\ComponentType\Discount;

use App\Models\Component;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Component\ComponentType\ComponentTypeInterface;
use App\Repositories\Product\ProductRepository;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class DiscountProductType2 implements ComponentTypeInterface
{
    public function get($record)
    {

    }

    public function filterAndExtraInput()
    {

        $categories = app(CategoryRepository::class)->getAllCategoryMainPluck();
        $branches = app(BranchRepository::class)->getAllBracnhMainPluck();
        $extra = [
            [
                "component" => "input-file",
                "type" => "file",
                "title" => "تصویر",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "image",
                "validation" => 'required|image',
                "validationMessage" => ['required' => 'فیلد تصویر اجباری است', 'image' => 'فایل انتخاب شده صحیح نیست'],
            ],
            [
                "component" => "input",
                "type" => "url",
                "title" => "لینک مشاهده بیشتر ",
                "required" => true,
                "is-array" => false,
                "value" => null,
                "min-count" => null,
                "name" => "link_more",
                "validation" => 'required|url',
                "validationMessage" => ['required' => 'فیلد لینک اجباری است', 'url' => 'در این فیلد باید لینک وارد کنید'],
            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "عنوان",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "title",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد عنوان اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],

            ],
            [
                "component" => "input",
                "type" => "color",
                "title" => "رنگ پس زمینه",
                "required" => true,
                "is-array" => false,
                "value" => null,
                "min-count" => null,
                "name" => "background_color",
                "validation" => 'required',
                "validationMessage" => ['required' => 'فیلد رنگ اجباری است'],
            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "متن دکمه",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "btn_text_more",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد متن دکمه اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],
            ],
        ];
        $filter = [
            [
                "component" => "select",
                "multi-select" => true,
                "title" => "دسته بندی",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "category_id",
                "value" => $categories,
                "validation" => 'nullable|numeric',
                "validationMessage" => ["numeric" => "فیلد دسته بندی به درستی انتخاب نشده است"],
            ],
            [
                "component" => "select",
                "multi-select" => false,
                "title" => "فروشنده",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "branch_id",
                "value" => $branches,
                "validation" => 'nullable|numeric',
                "validationMessage" => ["numeric" => "فیلد دسته بندی به درستی انتخاب نشده است"],
            ],
            [

                "component" => "select",
                "multi-select" => false,
                "title" => "شیوه مرتب سازی",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "name" => "order_by",
                "value" => ['desc' => 'آخر به اول', 'asc' => 'اول به آخر'],
                "validation" => 'required',
                "validationMessage" => ['required' => "فیلد ستون مرتب سازی اجباری است"],
            ],
            [
                "component" => "select",
                "multi-select" => false,
                "title" => "ستون مرتب سازی",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "name" => "order_by_field",
                "value" => ['id' => 'آیدی', 'order' => 'اولویت'],
                "validation" => 'required',
                "validationMessage" => ['required' => "فیلد ستون مرتب سازی اجباری است"],
            ],
            [
                "component" => "input",
                "type" => "number",
                "title" => "شروع قیمت",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "price_start",
                "value" => null,
                "validation" => 'nullable|numeric|min:1000',
                "validationMessage" => ['numeric' => "فیلد حداقل قیمت صحیح نیست", 'min' => "حداقل باید 1000 تومان وارد شود"],
            ],
            [
                "component" => "input",
                "type" => "number",
                "title" => "پایان قیمت",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "price_end",
                "value" => null,
                "validation" => 'nullable|numeric|min:1000',
                "validationMessage" => ['numeric' => "فیلد حداقل قیمت صحیح نیست", 'min' => "حداقل باید 1000 تومان وارد شود"],
            ],
        ];
        return ['filter' => $filter, 'extra' => $extra];

    }

    public function getFront($record, $request)
    {
        if ($record->filter != null)
            $filter = array_merge($record->filter, $request);
        else
            $filter = $request;
        return app(ProductRepository::class)->getByFilterFront($filter);
    }

    public function store($data)
    {
        try {
            $data['code'] = Str::random(10);
            $data['is_request'] = 'true';
            $data['slug'] = "home";

            $data['name_component'] = "DiscountProductType2";

            unset($data['type']);
            Component::create($data);
            return ['data' => [], 'status' => 200, 'message' => 'عملیات درج با موفقیت انجام شد'];
        } catch (\Exception $exception) {
            return ['data' => [], 'status' => 500, 'message' => $exception->getMessage()];
        }
    }
}
