<?php

namespace App\Repositories\Component\ComponentType\Register;

use App\Models\Component;
use App\Repositories\Component\ComponentType\ComponentTypeInterface;
use App\Repositories\Product\ProductRepository;
use Illuminate\Support\Str;

class RegisterSeller1 implements ComponentTypeInterface
{
    public function get($record)
    {

    }

    public function filterAndExtraInput()
    {

        $extra = [
            [
                "component" => "input-file",
                "type" => "file",
                "title" => "تصویر",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "image",
                "validation" => 'required|image',
                "validationMessage" => ['required' => 'فیلد تصویر اجباری است', 'image' => 'فایل انتخاب شده صحیح نیست'],
            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "عنوان",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "title",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد عنوان اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],

            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "توضیح کوتاه",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "sub_description",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد عنوان اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],

            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "توضیح",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "text",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد عنوان اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],

            ],

            [
                "component" => "input",
                "type" => "text",
                "title" => "متن دکمه",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "btn_text",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد متن دکمه اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],
            ],
        ];

        $filter = [];
        return ['filter' => $filter, 'extra' => $extra];
    }

    public function getFront($record, $request)
    {

        if ($record->filter != null)
            $filter = array_merge($record->filter, $request);
        else
            $filter = $request;

        return app(ProductRepository::class)->getByFilterFront($filter);
    }

    public function store($data)
    {
        try {
            $data['code'] = Str::random(10);
            $data['is_request'] = 'true';
            $data['slug'] = "home";

            $data['name_component'] = "RegisterSeller1";

            unset($data['type']);
            Component::create($data);
            return ['data' => [], 'status' => 200, 'message' => 'عملیات درج با موفقیت انجام شد'];
        } catch (\Exception $exception) {
            return ['data' => [], 'status' => 500, 'message' => $exception->getMessage()];
        }
    }
}
