<?php

namespace App\Repositories\Component\ComponentType\Slider;

use App\Models\Component;
use App\Repositories\Component\ComponentType\ComponentTypeInterface;
use App\Repositories\Slider\SliderRepository;
use Illuminate\Support\Str;

class FourthSlider implements ComponentTypeInterface
{
    public function get($record)
    {

    }

    public function filterAndExtraInput()
    {

        $extra = [
            [
                "component" => "array-data",
                "minCount" => 4,
                "fixCount" => false,
                "name" => "images",

                "params" => [[
                    "component" => "input-file",
                    "type" => "file",
                    "title" => "تصویر",
                    "required" => true,
                    "is-array" => true,
                    "min-count" => null,
                    "value" => null,
                    "name" => "image",
                    "validation" => 'required|image',
                    "validationMessage" => ['required' => 'فیلد تصویر اجباری است', 'image' => 'فایل انتخاب شده صحیح نیست'],
                ],
                    [
                        "component" => "input",
                        "type" => "url",
                        "title" => "لینک ",
                        "required" => false,
                        "is-array" => false,
                        "value" => null,
                        "min-count" => null,
                        "name" => "link",
                        "validation" => 'nullable|url',
                        "validationMessage" => ['required' => 'فیلد لینک اجباری است', 'url' => 'در این فیلد باید لینک وارد کنید'],
                    ],
                    [
                        "component" => "input",
                        "type" => "text",
                        "title" => "عنوان",
                        "required" => true,
                        "is-array" => false,
                        "min-count" => null,
                        "value" => null,
                        "name" => "title",
                        "validation" => 'required|min:3',
                        "validationMessage" => ['required' => 'فیلد عنوان اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],
                    ]],
            ],
        ];
        $filter = [];
        return ['filter' => $filter, 'extra' => $extra];
    }

    public function store($data)
    {
        try {
            $data['code'] = Str::random(10);
            $data['is_request'] = 'false';
            $data['slug'] = "home";

            $data['name_component'] = "FourthSlider";

            unset($data['type']);
            Component::create($data);
            return ['data' => [], 'status' => 200, 'message' => 'عملیات درج با موفقیت انجام شد'];
        } catch (\Exception $exception) {
            return ['data' => [], 'status' => 500, 'message' => $exception->getMessage()];
        }
    }

    public function getFront($record, $request)
    {
        if (isset($record->filter) and $record->filter != null)
            $filter = array_merge($record->filter, $request);
        else
            $filter = $request;
        $filter['type'] = 'fourth-slider';
        return app(SliderRepository::class)->getByFilterFront($filter);
    }
}
