<?php

namespace App\Repositories\Component\ComponentType\seller;

use App\Models\Component;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Component\ComponentType\ComponentTypeInterface;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;


class SellerSliderType1 implements ComponentTypeInterface
{
    public function get($record)
    {

    }
    public function store($data)
    {
        try {
            $data['code'] = Str::random(10);
            $data['is_request'] = 'true';
            $data['slug'] = "home";

            $data['name_component'] = "SellerSliderType1";

            unset($data['type']);
            Component::create($data);
            return ['data' => [], 'status' => 200, 'message' => 'عملیات درج با موفقیت انجام شد'];
        } catch (\Exception $exception) {
            return ['data' => [], 'status' => 500, 'message' => $exception->getMessage()];
        }
    }

    public function filterAndExtraInput()
    {

        $categories = app(CategoryRepository::class)->getAllCategoryMainPluck();
        $extra = [
            [
                "component" => "input",
                "type" => "url",
                "title" => "لینک مشاهده بیشتر ",
                "required" => true,
                "is-array" => false,
                "value" => null,
                "min-count" => null,
                "name" => "link_more",
                "validation" => 'required|url',
                "validationMessage" => ['required' => 'فیلد لینک اجباری است', 'url' => 'در این فیلد باید لینک وارد کنید'],
            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "عنوان",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "title",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد عنوان اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],

            ],
            [
                "component" => "input",
                "type" => "text",
                "title" => "متن بیشتر",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "btn_text_more",
                "validation" => 'required|min:3',
                "validationMessage" => ['required' => 'فیلد متن دکمه اجباری است', 'min' => 'حداقل سه کاراکتر وارد کنید'],
            ],
        ];
        $filter = [
            [
                "component" => "multiSelect",
                "multi-select" => true,
                "title" => "دسته بندی",
                "required" => false,
                "is-array" => true,
                "min-count" => null,
                "name" => "category_id",
                "value" => $categories,
                "validation" => 'required|Array',
                "validationChild" => 'required|numeric',
                "validationMessage" => ["numeric" => "فیلد دسته بندی به درستی انتخاب نشده است"],
                "validationMessageChild" => ["numeric" => "فیلد دسته بندی به درستی انتخاب نشده است"],

            ],
            [

                "component" => "select",
                "multi-select" => false,
                "title" => "شیوه مرتب سازی",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "name" => "sort_type",
                "value" => ['desc' => 'آخر به اول', 'asc' => 'اول به آخر'],
                "validation" => 'required',
                "validationMessage" => ['required' => "فیلد ستون مرتب سازی اجباری است"],
            ],
            [
                "component" => "select",
                "multi-select" => false,
                "title" => "ستون مرتب سازی",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "name" => "sort_column",
                "value" => ['id' => 'آیدی', 'order' => 'اولویت'],
                "validation" => 'required',
                "validationMessage" => ['required' => "فیلد ستون مرتب سازی اجباری است"],
            ]
        ];
        return ['filter' => $filter, 'extra' => $extra];

    }
    public function getInputFilterAndExtra()
    {
        $extra = [
            [
                "type" => "link",
                "title" => "لینک مشاهده بیشتر ",
                "required" => true,
                "is-array" => false,
                "value" => null,
                "min-count" => null,
                "name" => "link_more",
            ],
            [
                "type" => "text",
                "title" => "عنوان دکمه",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "title_more",
            ],
            [
                "type" => "text",
                "title" => "عنوان",
                "required" => true,
                "is-array" => false,
                "min-count" => null,
                "value" => null,
                "name" => "title",
            ]
        ];

        $filter = [
            [
                "type" => "multi-select",
                "tile" => "دسته بندی",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "category_id",
                "value" => null,
            ],
            [
                "type" => "select",
                "tile" => "شیوه مرتب سازی",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "order_by",
                "value" => ['desc' => 'آخر به اول', 'asc' => 'اول به آخر'],
            ],
            [
                "type" => "select",
                "tile" => "ستون مرتب سازی",
                "required" => false,
                "is-array" => false,
                "min-count" => null,
                "name" => "order_by_id",
                "value" => ['id' => 'آیدی', 'order' => 'اولویت'],
            ]
        ];
        return ['filter' => $filter , 'extra' => $extra];

    }

    public function getFront($record, $request)
    {
        if (isset($record->filter) and $record->filter != null)
            $filter = array_merge($record->filter, $request);
        else
            $filter = $request;

        $filter['is_product']=true;
        return app(BranchRepository::class)->getWithFilter($filter);
    }
}
