<?php

namespace App\Repositories\Coupon;

use App\Models\Coupon;
use App\Repositories\BaseRepository\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Coupon $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $extraTypes = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%   ' . $filter['search'] . '%');
                }
                if (isset($filter['branch_id']) && !empty($filter['branch_id'])) {
                    $q->where('branch_id', $filter['branch_id']);
                }
            });
            if ($paginate)
                return $extraTypes->paginate(25);
            return $extraTypes->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function storeA($data)
    {
        return DB::transaction(function () use ($data) {
            try {
                $coupon = new Coupon();
                $coupon->title = $data['title'];
                $coupon->code = $data['code'];
                $coupon->branch_id = $data['branch_id'] ?? 0;
                $coupon->type = $data['type'] ?? 1;
                $coupon->percent = $data['percent'] ?? 0;
                $coupon->price = $data['price'] ?? 0;
                $coupon->active_from = $data['active_from'] ?? 0;
                $coupon->active_to = $data['active_to'] ?? 0;
                $coupon->limit_uses = $data['limit_uses'] ?? false;
                $coupon->limit_user = $data['limit_user'] ?? false;
                $coupon->limit_branch = $data['limit_branch'] ?? false;
                $coupon->used_count = $data['used_count'] ?? 0;
                $coupon->max_price_discount = $data['max_price_discount'];
                $coupon->min_price_order = $data['min_price_order'];
                $coupon->condition_type = $data['condition_type'];
                $coupon->percent_system = $data['percent_system'];
                $coupon->percent_branch = $data['percent_branch'];
                $coupon->save();
                if ($coupon->limit_user)
                    $coupon->users()->attach($data['user_ids']);
                if ($coupon->limit_branch)
                    $coupon->branches()->attach($data['branch_ids']);
                return $coupon;
            } catch (\Exception $e) {
                Log::error($e->getMessage());
                return false;
            }
        });
    }


    public function getActiveList()
    {
        try {
            $now = Carbon::now();
            return $this->model->where('active_from', '<=', $now)->where('active_to', '>=', $now)->with('branch:id,title')->paginate(25);
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }

    }



}
