<?php

namespace App\Repositories\Delivery;

use App\Models\Setting;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Delivery\DeliveryType\ComponentByArea;
use App\Repositories\Delivery\DeliveryType\ComponentByAreaManagement;
use App\Repositories\Delivery\DeliveryType\ComponentByKm;
use App\Repositories\DeliveryType\DeliveryTypeRepository;
use App\Repositories\Setting\SettingRepository;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;

class DeliveryRepository implements RepositoryInterface
{
    protected $deliveryRep;

    public function __construct()
    {
        $settingCostType = app(SettingRepository::class)->getSettingWithName('deliveryCostType')['value'] ?? "kilometre";
        if ($settingCostType == 'kilometre')
            $this->deliveryRep = app(ComponentByKm::class);
        else
            $this->deliveryRep = app(ComponentByArea::class);
    }

    public function getDeliveryTypes($branchId): array
    {
        $branch = app(BranchRepository::class)->show($branchId);
        $deliveryTypes = $branch->deliveryTypes()->get()->toArray();
        return ['status' => 200, 'data' => $deliveryTypes, 'message' => null];
    }

    public function checkAccessAddress($orderId, $deliveryTypeId, $addressId): array
    {
        $deliveryType = app(DeliveryTypeRepository::class)->show($deliveryTypeId);
        if ($deliveryType->is_address) {
            if ($addressId == null)
                return ['status' => 400, 'message' => 'آدرس نادرست است', 'data' => ['check' => false]];
            return $this->deliveryRep->checkAccessAddress($orderId, $addressId);
        } else
            return ['status' => 200, 'data' => ['check' => true], 'message' => null];
    }

    public function getCostDeliveryOrder($orderId, $deliveryTypeId,$areaResult=null): array
    {
        if ($deliveryTypeId == null) {
            return ['status' => 200, 'data' => ['cost' => 0], 'message' => 'روش ارسال انتخاب نشده است '];
        }

        // Check if delivery method is 'serve' or 'actual' - no shipping cost needed
        $deliveryMethod = is_object($deliveryTypeId) ? $deliveryTypeId->delivery_method : null;
        if (in_array($deliveryMethod, ['serve', 'actual'])) {
            return ['status' => 200, 'data' => ['cost' => 0], 'message' => 'برای روش تحویل حضوری یا سرو در محل هزینه ارسال وجود ندارد'];
        }

            
            $configDelivery= Setting::where('name', 'shippingType')->where('branch_id', null)->latest()->first()->toArray()['value']??'withArea';


        if ($configDelivery=="withArea")
            return app(ComponentByAreaManagement::class)->calculateDeliveryCost($orderId,$areaResult);
        else if($configDelivery=="withKilometer"){
            return app(ComponentByKm::class)->calculateDeliveryCost($orderId);
        }

        return ['status' => 200, 'cost' => 0, 'message' => $configDelivery['title']??''];
    }
}
