<?php

namespace App\Repositories\Delivery\DeliveryType;

use App\Repositories\Address\AddressRepository;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Setting\SettingRepository;
use Illuminate\Support\Facades\Log;

class ComponentByAreaManagement implements DeliveryTypeInterface
{
    public function calculateDeliveryCost($orderId): array
    {
        $order = app(OrderRepository::class)->show($orderId);

        // Check if delivery method is 'serve' or 'actual' - no shipping cost needed
        if ($order && $order->deliveryType && in_array($order->deliveryType->delivery_method, ['serve', 'actual'])) {
            return ['status' => 200, 'message' => 'برای روش تحویل حضوری یا سرو در محل هزینه ارسال وجود ندارد', 'data' => ['cost' => 0]];
        }

        $address = $order->address_order;
        if ($address == null)
            return ['status' => 404, 'message' => 'آدرس نامعتبر است', 'data' => null];
        $area = $address->area;


        if ($area == null)
            return ['status' => 404, 'message' => 'آدرس نامعتبر است', 'data' => null];
        $branch = $order->branch;
        if ($branch == null)
            return ['status' => 500, 'message' => 'فروشنده یافت نشد', 'data' => null];


        $areaPrice = $branch->deliveryAreas()->withPivot('shipment_price')->where('area_id', $address->area_id)->select('shipment_price')->first();
        if ($areaPrice != null)
            return ['status' => 200, 'message' => '', 'data' => ['cost' =>['value'=>$areaPrice->shipment_price]]];


        $settingCostDelivery = app(SettingRepository::class)->getSettingWithName('shippingCost');

        if ($settingCostDelivery != null)
            return ['status' => 200, 'message' => '', 'data' => ['cost' => $settingCostDelivery]];


        return ['status' => 200, 'message' => '', 'data' => ['cost' => 0]];
    }


    public function checkAccessAddress($orderId, $addressId): array
    {
        $order = app(OrderRepository::class)->show($orderId);
        $address = app(AddressRepository::class)->show($addressId);
        $branch = app(BranchRepository::class)->show($order->branch_id);
        if ($order == null || $address == null || $order->branch_id == null) {
            return ['status' => 400, 'message' => 'آدرس نادرست است', 'data' => ['check' => false]];
        }
        $checkBranchArea = $branch->deliveryAreas->where('id', $address->area_id)->first();
        if ($checkBranchArea == null)
            return ['status' => 400, 'message' => 'آدرس انتخاب شده در محدوده فروشنده نمیباشد', 'data' => ['check' => false]];

        return ['status' => 200, 'message' => 'آدرس با موفقیت انتخاب شد.', 'data' => ['check' => true]];
    }
}
