<?php

    namespace App\Repositories\Delivery\DeliveryType;

    use App\Repositories\Address\AddressRepository;
    use App\Repositories\Order\OrderRepository;
    use Illuminate\Support\Facades\Log;

    class ComponentByKm implements DeliveryTypeInterface
    {
        public function calculateDeliveryCost($orderId): array
        {
            $order = app(OrderRepository::class)->show($orderId);

            // Check if delivery method is 'serve' or 'actual' - no shipping cost needed
            if ($order && $order->deliveryType && in_array($order->deliveryType->delivery_method, ['serve', 'actual'])) {
                return ['status' => 200, 'data' => ['cost' => 0], 'message' => 'برای روش تحویل حضوری یا سرو در محل هزینه ارسال وجود ندارد'];
            }

            if ($order == null || $order->address_id == null || $order->branch_id == null) {
                return ['status' => 422, 'data' => ['cost' => 0], 'message' => 'اطلاعات یافت نشد'];
            } else {
                $settingRep = app(\App\Repositories\Setting\SettingRepository::class);
                $settingShipment = $settingRep->getSettingShippingTypeAndPrice();

                if (!isset($order->branch->lat) || !isset($order->branch->lng) || !isset($order->address_order->lat) || !isset($order->address_order->lng)) {
                    return $order->branch->lat;
                }
                $point1 = [
                    'latitude' => $order->branch->lat,
                    'longitude' => $order->branch->lng,
                ];
                $point2 = [
                    'latitude' => $order->address_order->lat,
                    'longitude' => $order->address_order->lng,
                ];
                $distance = haversineDistance($point1, $point2);

                if (isset($settingShipment['deliveryFreeKilometer']) and $distance < $settingShipment['deliveryFreeKilometer']){

                    return ['status' => 200, 'data' => ['cost' => 0], 'message' => null];
                }

                if (isset($settingShipment['fixedShippingKilometer']) and $distance > $settingShipment['fixedShippingKilometer']) {

                    $maxKilometer = $distance - $settingShipment['fixedShippingKilometer'];
                    $maxPrice = $maxKilometer * $settingShipment['shippingCost'];
                    return ['status' => 200, 'data' => ['cost' =>  number_format($settingShipment['fixedShippingCost'] + $maxPrice, 0, '.', '')], 'message' => null];
                }
                return ['status' => 200, 'data' => ['cost' =>  number_format($settingShipment['fixedShippingCost'] ?? 0, 0, '.', '')], 'message' => null];
            }
        }

        public function checkAccessAddress($orderId, $addressId): array
        {

            $order = app(OrderRepository::class)->show($orderId);
            if ($order == null || $addressId == null || $order->branch_id == null) {
                return ['status' => 400, 'message' => 'آدرس نادرست است', 'data' => ['check' => false]];
            } else {
                $addressRep = app(AddressRepository::class);
                $address = $addressRep->show($addressId);
                if (!$address || $address->user_id != auth()->id())
                    return ['status' => 400, 'message' => 'آدرس نادرست است', 'data' => ['check' => false]];
                $point1 = [
                    'latitude' => $order->branch->lat,
                    'longitude' => $order->branch->lng,
                ];
                $point2 = [
                    'latitude' => $address->lat,
                    'longitude' => $address->lng,
                ];
                $maxDistance = app(\App\Repositories\Setting\SettingRepository::class)->maxDistance();
                $distance = haversineDistance($point1, $point2);

                if ($distance > $maxDistance)
                    return ['status' => 200, 'message' => 'آدرس انتخابی با آشپز خارج از محدوده است و شامل هزینه اضافی میشود', 'data' => ['check' => true]];
                return ['status' => 200, 'message' => 'آدرس با موفقیت ثبت شد', 'data' => ['check' => true]];
            }
        }
    }
