<?php

namespace App\Repositories\DeliveryType;

use App\Models\DeliveryType;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;

class DeliveryTypeRepository extends BaseRepository implements RepositoryInterface
{
    public function __construct(DeliveryType $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
            });
            if ($paginate)
                return $data->paginate(10);
            else
                return $data->get();

        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }
}
