<?php

namespace App\Repositories\ExportImport;

use App\Exports\BranchesExport;
use App\Exports\MaterialsExport;
use App\Exports\OrdersExport;
use App\Exports\ProductsExport;
use App\Exports\TransactionsExport;
use App\Exports\UsersExport;
use App\Models\ExportImports;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

abstract class  EloquentRepository extends BaseRepository
{
    public function __construct(ExportImports $model)
    {
        parent::__construct($model);
    }

    protected $path = '/excel/';


    public function getWithFilter(array $filter = [], $paginate = true)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['type']) && !empty($filter['type'])) {
                    $q->where('type', $filter['type']);
                }
            })->orderBy('id', 'desc');
            if ($paginate)
                return $data->paginate(15);
            else
                return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }


    public function createExcelFileTransactions($data)
    {
        $export = new TransactionsExport($data);
        $name = $this->path . Str::random(16) . '.xlsx';
        $this->store(['file' => env('APP_URL') . $name, 'type' => 'export']);
        return Excel::store($export, $name, 'local');
    }

    public function createExcelFileOrders($data)
    {
        $export = new OrdersExport($data);
        $name = $this->path . Str::random(16) . '.xlsx';
        $this->store(['file' => env('APP_URL') . $name, 'type' => 'export']);
        return Excel::store($export, $name, 'local');
    }

    public function createExcelFileUsers($data)
    {
        $export = new UsersExport($data);
        $name = $this->path . Str::random(16) . '.xlsx';
        $this->store(['file' => env('APP_URL') . $name, 'type' => 'export']);
        return Excel::store($export, $name, 'local');
    }

    public function createExcelFileProducts($data)
    {
        $export = new ProductsExport($data);
        $name = $this->path . Str::random(16) . '.xlsx';
        $this->store(['file' => env('APP_URL') . $name, 'type' => 'export']);
        return Excel::store($export, $name, 'local');
    }

    public function createExcelFileMaterials($data)
    {
        $export = new MaterialsExport($data);
        $name = $this->path . Str::random(16) . '.xlsx';
        $this->store(['file' => env('APP_URL') . $name, 'type' => 'export']);
        return Excel::store($export, $name, 'local');
    }

    public function createExcelFileBranches($data)
    {
        $export = new BranchesExport($data);
        $name = $this->path . Str::random(16) . '.xlsx';
        $this->store(['file' => env('APP_URL') . $name, 'type' => 'export']);
        return Excel::store($export, $name, 'local');
    }
}
