<?php

namespace App\Repositories\ExtraType;

use App\Models\ExtraType;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(ExtraType $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $extraTypes = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
                if (isset($filter['branch_id']) && !empty($filter['branch_id'])) {
                    $q->where('branch_id', $filter['branch_id']);
                }
            });
            if ($paginate)
                return $extraTypes->paginate(25);

            return $extraTypes->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }
}
