<?php

namespace App\Repositories\Favorite;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

abstract class  EloquentRepository
{
    abstract public function model();

    public function getAllIds()
    {
        $model = $this->model();
        $ids = $model::where('user_id', auth()->id())->select('id', 'type')->get()->groupBy('type')->toArray();
        return $ids;
    }

    public function getWithType($type)
    {
        $model = $this->model();
        $ids = $model::where('user_id', auth()->id())->where('type', $type)->with($type)->whereHas($type)->get()->toArray();
        return $ids;
    }

    public function checkStatus($type, $target_id)
    {
        $model = $this->model();
        $ids = $model::where('user_id', auth()->id())->where('type', $type)->where('target_id', $target_id)->first();
        return $ids;
    }

    public function create($data)
    {
        $model = $this->model();
        $check = $model::where('user_id', auth()->id())->where('type', $data['type'])->where('target_id', $data['target_id'])->first();
        if (!$check) {
            $data['user_id'] = auth()->id();
            return $model::create($data);
        } else {
            return $check;
        }
        return false;
    }

    public function remove($data)
    {
        $model = $this->model();
        $model::where('user_id', auth()->id())->where('type', $data['type'])->where('target_id', $data['target_id'])->delete();
        return true;
    }
}
