<?php

namespace App\Repositories\Material;

use App\Models\Material;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\ExportImport\ExportImportRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Material $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $materials = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
                if (isset($filter['category_id']) && !empty($filter['category_id'])) {
                    $q->where('category_id', $filter['category_id']);
                }
            })->with('category', 'unit');

            if (isset($filter['export']) and $filter['export'] == true) {
                $export = clone $materials;
                app(ExportImportRepository::class)->createExcelFileMaterials($export->get()->toArray());
            }
            if ($paginate)
                return $materials->paginate(25);

            return $materials->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }
}
