<?php

namespace App\Repositories\NotificationMobile;

use App\Enums\NotificationType;
use App\Models\NotificationMobile;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;

interface NotificationMobileRepositoryInterface
{
    public function getAll(array $filters = []): Collection;
    public function getPaginated(array $filters = [], int $perPage = 15): LengthAwarePaginator;
    public function findById(int $id): ?NotificationMobile;
    public function create(array $data): NotificationMobile;
    public function update(int $id, array $data): bool;
    public function delete(int $id): bool;
    public function getByBranch(int $branchId): Collection;
    public function getByType(NotificationType $type): Collection;
    public function getByBranchAndType(int $branchId, NotificationType $type): Collection;
    public function getMobileNumbers(int $branchId, NotificationType $type): array;
    public function getActiveMobileNumbers(int $branchId, NotificationType $type): array;
}
