<?php

namespace App\Repositories\Order;

use App\Models\Branch;
use App\Models\Extra;
use App\Models\Order;
use App\Models\OrderCart;

class OrderRepository extends EloquentRepository implements RepositoryInterface
{
    public function model()
    {
        return Order::class;
    }

    public function modelOrderCart()
    {
        return OrderCart::class;
    }

    public function modelExtras()
    {
        return Extra::class;
    }


    public function getByCodeGateway($codeGateway)
    {
        return $this->model->where('payment_code_gateway', $codeGateway)->first();
    }
    public function getByPaymentCode($paymentCode)
    {
        return $this->model->where('payment_code', $paymentCode)->first();
    }
}
