<?php

namespace App\Repositories\Page;

use App\Models\Page;
use App\Repositories\BaseRepository\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

abstract class  EloquentRepository extends BaseRepository
{


    public function __construct(Page $model)
    {
        parent::__construct($model);
    }

    public function getListPage()
    {
        return $this->model->select('title',"slug")->get()->toArray();

    }

    public function getWithSlug($slug)
    {
        return $this->model->where('slug', $slug)->first();
    }
}
