<?php

namespace App\Repositories\Payment\PaymentGateways;

use App\Repositories\Order\OrderRepository;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class MeliBankGateway implements PaymentGatewayInterface
{
    public function setPay($paymentCode, $amount, $callbackRoute = null, $orderId = null): array
    {

        if ($callbackRoute == null)
            $callbackRoute = route('payConfirm', ['gateway_id' => 1]);
        $MerchantId = env('SADAD_MERCHANT');
        $TerminalId = env('SADAD_TERMINAL_ID');
        $key = env('SADAD_TRANS_KEY');
        $amount2 = 10000;
        $si = $this->encrypt_pkcs7("$TerminalId;$orderId;$amount2", "$key");
        $data = [
            'TerminalId' => $TerminalId,
            'MerchantId' => $MerchantId,
            'ReturnUrl' => $callbackRoute,
            'Amount' => $amount2,
            'OrderId' => $orderId,
            'Description' => '',
            'Mobile' => '',
            'SignData' => $si,
            'LocalDateTime' => date("m/d/Y g:i:s a")
        ];
        $result = Http::withHeaders([
            'Content-Type' => 'application/json; charset=utf-8',
        ])->post('https://sadad.shaparak.ir/vpg/api/v0/Request/PaymentRequest', $data);
        if ($result->successful()) {
            $responseBody = $result->json();
            if ((int)$responseBody['ResCode'] == 0) {

                $Token = $responseBody['Token'];
                return [
                    'status' => 200,
                    'message' => 'با موفقیت درخواست ثبت شد.',
                    'data' => ['route' => "https://sadad.shaparak.ir/VPG/Purchase?Token=$Token", "codeGateway" => $Token]
                ];
            } else {
                return ['status' => 500, 'message' => 'خطا در ارتباط با درگاه', 'data' => null];
            }
        } else {
            return ['status' => 500, 'message' => 'خطا در ارسال درخواست به سرور درگاه', 'data' => $result->body()];
        }
    }


    public function confirmPay($data): array
    {
        $key = env('SADAD_TRANS_KEY');
        $OrderId = $data['OrderId'];
        $Token = $data['token'];
        $ResCode = $data['ResCode'];

        $order = app(OrderRepository::class)->show($OrderId);
        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => []];
        }

        $amount = $order->order_price - $order->wallet_use_price;

        if ($ResCode == 0) {
            $verifyData = [
                'Token' => $Token,
                'SignData' => $this->encrypt_pkcs7($Token, $key)
            ];

            $response = Http::withHeaders([
                'Content-Type' => 'application/json; charset=utf-8',
            ])->post('https://sadad.shaparak.ir/vpg/api/v0/Advice/Verify', $verifyData);

            if ($response->successful()) {
                $result = $response->json();
                if ((int)$result['ResCode'] == 0 /*and $result['Amount'] == $amount*/) {
                    return ['status' => 200, 'message' => 'پرداخت با موفقیت تایید شد.',
                        'data' => ['order' => $order, 'refId' => $result['RetrivalRefNo']]];
                } else {
                    return ['status' => 500, 'message' => 'خطا در تایید پرداخت: ' . $result['Description'], 'data' => ["order" => $order]];
                }
            } else {
                return ['status' => 500, 'message' => 'خطا در ارتباط با سرور درگاه پرداخت.', 'data' => ["order" => $order]];
            }
        }
        return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل مواجه شد.', 'data' => ["order" => $order]];
    }

    function encrypt_pkcs7($str, $key)
    {
        $key = base64_decode($key);
        $ciphertext = OpenSSL_encrypt($str, "DES-EDE3", $key, OPENSSL_RAW_DATA);
        return base64_encode($ciphertext);
    }

}
