<?php

namespace App\Repositories\Payment\PaymentGateways;


use App\Models\ChargeWallet;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Payment\PaymentGateways\PaymentGatewayInterface;
use App\Repositories\Setting\SettingRepository;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class OmidPayGateway implements PaymentGatewayInterface
{
    public function setPay($paymentCode, $amount, $callbackRoute = null, $orderId = null): array
    {
        if ($callbackRoute == null)
            $callbackRoute = route('payConfirm', ['gateway_id' => 1]);
        $payload = [
            'WSContext' =>['UserId' => env('OMIDPAY_USER'), 'Password' => env('OMIDPAY_PASS')],
            'TransType' => 'EN_GOODS',
            'Amount' => (int)$amount * 10,
            'ReserveNum' => $paymentCode,
            'MerchantId' => env('OMIDPAY_MERCHANT'),
            'TerminalId' => env('OMIDPAY_TERMINAL_ID'),
            'RedirectUrl' => $callbackRoute,
        ];
        try {

            $url = 'https://ref.sayancard.ir/ref-payment/RestServices/mts/generateTokenWithNoSign/';
            $client = new Client();

            $response = $client->post($url, [
                'json' => $payload,
                'headers' => [
                    'Content-Type' => 'application/json'],
            ]);
            $result = (string)$response->getBody();
        } catch (\Exception $e) {
            return ['status' => 500, 'message' => 'خطا در ارتباط با درگاه پرداخت', 'data' => null];
        }

        if ($result['Result'] == "reSucceed") {
            return ['status' => 200, 'message' => 'با موفقیت درخواست ثبت شد.', 'data' => ['route' => "https://say.shaparak.ir/_ipgw_/merchant/token?language=fa&token=" . $result['Token'], 'codeGateway' => $result['Token']]];
        } else {
            return ['status' => 500, 'message' => 'خطا در ارتباط با درگاه پرداخت', 'data' => null];
        }
    }


    public function confirmPay($data): array
    {
        $MerchantID = env('OMIDPAY_TERMINAL_ID');
        $trans_id = $data['RefNum'] ?? 0;
        $id_get = $data['ResNum'] ?? 0;
        $order = app(OrderRepository::class)->getByCodeGateway($id_get);
        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => []];
        }
        $amount = $order->order_price - $order->wallet_use_price - $order->cash_back_price;
        try {
            $payload = [
                'WSContext' => ['UserId' => env('OMIDPAY_USER'), 'Password' => env('OMIDPAY_PASS')],
                'RefNum' => (int)$trans_id,
                'Token' => $order->payment_code_gateway,
            ];
            $url = 'https://ref.sayancard.ir/ref-payment/RestServices/mts/verifyMerchantTrans/';
            $client = new Client();
            $response = $client->post($url, $payload);
            $result = (string)$response->getBody();
            Log::info("Response from bitPay: " . json_encode($result));
        } catch (\Exception $e) {
            Log::error("HTTP request failed: " . $e->getMessage());
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order ?? []]];
        }


        if ($result['Result'] == "reSucceed") {
            return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $result['RefNum']]];
        }
        return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order ?? []]];
    }

    public function confirmChargePay($data): array
    {
        $merchantSetting = app(SettingRepository::class)->getSettingWithName('bitPay');
        $MerchantID = $merchantSetting['value'];
        $trans_id = $data['trans_id'] ?? 0;
        $id_get = $data['id_get'] ?? 0;
        $order = ChargeWallet::where('payment_code_gateway', $id_get)->first();
        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => []];
        }
        $amount = $order->amount;
        try {
            $payload = [
                'api' => "$MerchantID",
                'trans_id' => (int)$trans_id,
                'id_get' => (int)$id_get,
                'amount' => $amount * 10,
            ];
            $url = 'https://bitpay.ir/payment/gateway-result-second';
            $client = new Client();
            $response = $client->post($url,
                ['form_params' => $payload]
            );
            $result = (string)$response->getBody();
            Log::info("Response from bitPay: " . json_encode($result));
        } catch (\Exception $e) {
            Log::error("HTTP request failed: " . $e->getMessage());
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order ?? []]];
        }

        if ((int)$result == 1 || (int)$result == 11) {
            return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $trans_id]];
        }
        return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order ?? []]];
    }
}
