<?php

namespace App\Repositories\Payment\PaymentGateways;


use App\Models\ChargeWallet;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Setting\SettingRepository;
use Illuminate\Support\Facades\Log;

class SepGateway implements PaymentGatewayInterface
{
    public function setPay($paymentCode, $amount, $callbackRoute = null, $orderId = null): array
    {
        if ($callbackRoute == null)
            $callbackRoute = route('payConfirm', ['gateway_id' => 1]);

        $TerminalId = app(SettingRepository::class)->getSettingWithName('sepPay')['value'];



        $url = "https://sep.shaparak.ir/onlinepg/onlinepg";
        $data = [
            'TerminalId' => $TerminalId,  // شماره ترمینال
            'ResNum' => $paymentCode,    // شماره رسید
            'TotalAmount' => $amount,    // مبلغ کل
            'Optional1' => '0',          // اختیاری
            'Optional2' => '0',
            'Optional3' => '0',
            'Optional4' => '0',
            'Optional5' => '0',
            'Optional6' => '0',
            'ResNum1' => 'ResNum1',
            'ResNum2' => 'ResNum2',
            'Optional7' => '0',
            'CallbackRoute' => $callbackRoute // آدرس بازگشت
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data); // ارسال داده‌ها به‌صورت POST
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/x-www-form-urlencoded"
        ]);

        $response = curl_exec($ch);
        dd($response);




        $client = new \soapclient('https://sep.shaparak.ir/Payments/InitPayment.asmx?WSDL');
        $result = $client->RequestToken(
            $TerminalId,            /// MID
            $paymentCode,        /// ResNum
            $amount            /// TotalAmount
            , '0'            /// Optional
            , '0'            /// Optional
            , '0'            /// Optional
            , '0'            /// Optional
            , '0'            /// Optional
            , '0'            /// Optional
            , 'ResNum1'        /// Optional
            , 'ResNum2'        /// Optional
            , '0'            /// Optional
            , $callbackRoute    /// Optional
        );


//        $client = new \SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
//        $result = $client->PaymentRequest([
//            'action' => "token",
//            'TerminalId' => "$TerminalId",
//            'Amount' => $amount,
//            'ResNum' => $paymentCode,
//            'CellNumber' => '',
//            'RedirectUrl' => $callbackRoute,
//        ]);
        if ($result->Status == 1) {
            return ['status' => 200, 'message' => 'با موفقیت درخواست ثبت شد.', 'data' => ['route' => 'https://sep.shaparak.ir/OnlinePG/OnlinePG' . $result->token,
                'codeGateway' => $result->Authority]];
        } else {
            return ['status' => 500, 'message' => $result->errorDesc, 'data' => null];
        }
    }


    public function confirmPay($data): array
    {
        $RefNum = $_POST['RefNum'];
        $State = $_POST['State'];
        if ($State != 'OK') {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];

        }

        $codeGateway = $data['ResNum'];
        $order = app(OrderRepository::class)->getByCodeGateway($codeGateway);

        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
        }


        try {
            $amount = $order->order_price - $order->wallet_use_price - $order->cash_back_price;
            if ($amount != $data['Amount'])
                return ['status' => 404, 'message' => 'مشکل در مبلغ سفارش!', 'data' => ['order' => $order]];


            $MerchantID = app(SettingRepository::class)->getSettingWithName('sepPay')['value'];
            $Verify_URL = 'https://sep.shaparak.ir/payments/referencepayment.asmx?WSDL';
            $soapClient = new \SoapClient($Verify_URL, [
                'trace' => true,  // برای مشاهده درخواست و پاسخ
                'exceptions' => true, // پرتاب استثنا در صورت خطا
            ]);
            $response = $soapClient->verifyTransaction([
                'refNum' => $RefNum,
                'merchantId' => $MerchantID,
            ]);

            // بررسی نتیجه
            if ($response <= 0) {
                return [
                    'su ccess' => false,
                    'message' => 'Verification failed',
                    'error_code' => $response
                ];
            }

            if (isset($response->TransactionDetail->OrginalAmount) and $response->TransactionDetail->OrginalAmount==$amount and isset($response->Success) and $response->Success) {
                return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $response->TransactionDetail->RefNum]];
            }
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];

        } catch (\Exception $exception) {
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
        }
    }


    public
    function confirmChargePay($data): array
    {
        $codeGateway = $data['Authority'];
        $order = ChargeWallet::where('payment_code_gateway', $codeGateway)->first();
        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
        }
        $amount = $order->amount;
        $MerchantID = app(SettingRepository::class)->getSettingWithName('zarinpal')['value'];
        $client = new \SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
        $result = $client->PaymentVerification([
            'MerchantID' => $MerchantID,
            'Authority' => $codeGateway,
            "Amount" => $amount
        ]);
        if (isset($result->Status) and $result->Status == 100) {
            return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $result->RefID]];
        }
        return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
    }


}
