<?php

namespace App\Repositories\Payment\PaymentGateways;


use App\Enums\OrderStatus;
use App\Enums\TransactionType;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Payment\PaymentGateways\PaymentGatewayInterface;
use App\Repositories\Transaction\TransactionRepository;
use Illuminate\Support\Facades\Log;

class WalletGateway implements PaymentGatewayInterface
{
    public function setPay($paymentCode, $amount): array
    {
        $order = app(OrderRepository::class)->getByPaymentCode($paymentCode);
        $userWallet = (int)app(TransactionRepository::class)->userInventoryWithUser($order->user_id);
        if ($userWallet >= $amount) {
            $setTransaction = app(TransactionRepository::class)->storeP(['amount' => $amount * -1, 'user_id' => $order->user_id, 'transaction_type' => TransactionType::PAYORDER, 'target_id' => $order->id]);
            return ['status' => 200, 'data' => ['walletAmount' => $amount, 'route' => env('FrontUrl') . 'order?status=200&orderid=' . $order->id], 'message' => 'با موفقیت انجام شد '];

        } elseif ($userWallet > 0) {
            $walletPrice = $userWallet;
            $setTransaction = app(TransactionRepository::class)->storeP(['amount' => $walletPrice * -1, 'user_id' => $order->user_id, 'transaction_type' => TransactionType::PAYORDER, 'target_id' => $order->id]);
            return ['status' => 200, 'data' => ['walletAmount' => $walletPrice], 'message' => 'با موفقیت انجام شد '];
        }
        return ['status' => 200, 'data' => ['walletAmount' => 0], 'message' => 'با موفقیت انجام شد '];
    }

    public function confirmPay($data): array
    {
        $order = app(OrderRepository::class)->show($data['orderId']);
        if ($order->walletUsePrice != 0 and $order->order_status == OrderStatus::WATINGPAYMENT)
            app(TransactionRepository::class)->storeP(
                [
                    'amount' => $order->walletUsePrice,
                    'user_id' => $order->user_id,
                    'transaction_type' => TransactionType::PAYORDER,
                    'target_id' => $order->branch_id,
                    'description' => 'بازگشت پول بابت شکست در عملیات پرداخت'
                ]);
        return ['status' => 200, 'message' => 'مبلغ وجه با موفقییت برگشت خورد', 'data' => []];
    }
}
