<?php

namespace App\Repositories\Payment\PaymentGateways;


use App\Models\ChargeWallet;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Setting\SettingRepository;
use Illuminate\Support\Facades\Log;

class ZarinPalGateway implements PaymentGatewayInterface
{
    public function setPay($paymentCode, $amount, $callbackRoute = null, $orderId = null): array
    {
        if ($callbackRoute == null)
            $callbackRoute = route('payConfirm', ['gateway_id' => 1]);

        $MerchantID = app(SettingRepository::class)->getSettingWithName('zarinpal')['value'];
        $client = new \SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
        $result = $client->PaymentRequest([
            'MerchantID' => "$MerchantID",
            'Amount' => $amount,
            'order_id' => $paymentCode,
            'Description' => '',
            'Mobile' => '',
            'CallbackURL' => $callbackRoute,
        ]);
        if ($result->Status == 100) {
            return ['status' => 200, 'message' => 'با موفقیت درخواست ثبت شد.', 'data' => ['route' => 'https://www.zarinpal.com/pg/StartPay/' . $result->Authority,
                'codeGateway' => $result->Authority]];
        } else {
            return ['status' => 500, 'message' => 'خطا در ارتباطبا درگاه', 'data' => null];
        }
    }


    public function confirmPay($data): array
    {
        $codeGateway = $data['Authority'];
        $order = app(OrderRepository::class)->getByCodeGateway($codeGateway);
        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
        }
        try {

            $amount = $order->order_price - $order->wallet_use_price - $order->cash_back_price;
            $MerchantID = app(SettingRepository::class)->getSettingWithName('zarinpal')['value'];
            $client = new \SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
            $result = $client->PaymentVerification([
                'MerchantID' => $MerchantID,
                'Authority' => $codeGateway,
                "Amount" => $amount
            ]);

            if (isset($result->Status) and $result->Status == 100) {
                return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $result->RefID]];
            }
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];

        } catch (\Exception $exception) {
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
        }
    }


    public function confirmChargePay($data): array
    {
        $codeGateway = $data['Authority'];
        $order = ChargeWallet::where('payment_code_gateway', $codeGateway)->first();
        if ($order == null) {
            return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
        }
        $amount = $order->amount;
        $MerchantID = app(SettingRepository::class)->getSettingWithName('zarinpal')['value'];
        $client = new \SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
        $result = $client->PaymentVerification([
            'MerchantID' => $MerchantID,
            'Authority' => $codeGateway,
            "Amount" => $amount
        ]);
        if (isset($result->Status) and $result->Status == 100) {
            return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $result->RefID]];
        }
        return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
    }


}
