<?php

namespace App\Repositories\Payment\PaymentGateways;

use App\Models\ChargeWallet;
use App\Repositories\Order\OrderRepository;
use App\Repositories\Setting\SettingRepository;
use Illuminate\Support\Facades\Log;

class ZibalGateway implements PaymentGatewayInterface
{
    public function setPay($paymentCode, $amount, $callbackRoute = null, $orderId = null, $options = []): array
    {
        Log::info('1111111111111111111111111');
        if ($callbackRoute == null) {
            $callbackRoute = route('payConfirm', ['gateway_id' => 1]);
        }
        $TerminalId = app(SettingRepository::class)->getSettingWithName('zibal')['value'];
        $order = app(OrderRepository::class)->showA($orderId);

        $url = 'https://gateway.zibal.ir/v1/request';
        $data = [
            'merchant' => "$TerminalId",
            'amount' => $amount * 10,
            // "amount" => 10000,
            'callbackUrl' => $callbackRoute,
            'description' => 'خرید از فروشگاه: ' . $order->branch->title ?? '--' . 'شماره سفارش :' . $orderId,
            'orderId' => $orderId,
            'mobile' => $order->user->mobile ?? '--',
            'multiplexingInfos' => $options['multiplexingInfos'] ?? [],
        ];
        Log:
        info($data);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        Log::info($response);

        curl_close($ch);
        $response = json_decode($response);
        if ($response->result == 100) {
            return ['status' => 200, 'message' => 'با موفقیت درخواست ثبت شد.', 'data' => ['route' => 'https://gateway.zibal.ir/start/' . $response->trackId, 'codeGateway' => $response->trackId]];
        } else {
            return ['status' => 500, 'message' => 'خطا در عملیات', 'data' => null];
        }
    }

    public function confirmPay($data): array
    {
        try {
            $codeGateway = $data['trackId'];
            $order = app(OrderRepository::class)->getByCodeGateway($codeGateway);
            if ($order == null) {
                return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
            }

            if ($data['success'] != 1) {
                return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
            }

            $TerminalId = app(SettingRepository::class)->getSettingWithName('zibal')['value'];
            $url = 'https://gateway.zibal.ir/v1/verify';

            $parameters = [
                'merchant' => "$TerminalId",
                'trackId' => $data['trackId'],
            ];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parameters));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);
            // بررسی نتیجه
            if ($response->result == 201) {
                return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $order->payment_code_gateway]];
            }

            if ($response->result != 100) {
                return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
            }

            $amount = $order->order_price - $order->wallet_use_price - $order->cash_back_price;
            $amount = $amount * 10;
            if ($amount != $response->amount) {
                return ['status' => 404, 'message' => 'مشکل در مبلغ سفارش!', 'data' => ['order' => $order]];
            }

            if (isset($response->amount) and $response->amount == $amount) {
                return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $response->refNumber]];
            }
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
        } catch (\Exception $exception) {
            dd($exception);
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
        }
    }

    public function confirmChargePay($data): array
    {
        try {
            $codeGateway = $data['trackId'];
            $order = ChargeWallet::where('payment_code_gateway', $codeGateway)->first();
            if ($order == null) {
                return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
            }

            if ($data['success'] != 1) {
                return ['status' => 404, 'message' => 'سفارشی یافت نشد', 'data' => ['order' => $order]];
            }

            $TerminalId = app(SettingRepository::class)->getSettingWithName('zibal')['value'];
            $url = 'https://gateway.zibal.ir/v1/verify';

            $parameters = [
                'merchant' => "$TerminalId",
                'trackId' => $data['trackId'],
            ];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parameters));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);

            if ($response->result != 100) {
                return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
            }

            $amount = $order->amount;
            $amount = $amount * 10;
            if ($amount != $response->amount) {
                return ['status' => 404, 'message' => 'مشکل در مبلغ سفارش!', 'data' => ['order' => $order]];
            }

            if (isset($response->amount) and $response->amount == $amount) {
                return ['status' => 200, 'message' => '', 'data' => ['order' => $order, 'refId' => $response->refNumber]];
            }
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
        } catch (\Exception $exception) {
            dd($exception);
            return ['status' => 500, 'message' => 'عملیات پرداخت با مشکل موجه شد.', 'data' => ['order' => $order]];
        }
    }
}
