<?php 

namespace App\Repositories;

use App\Models\PaymentTransaction;

class PaymentTransactionRepository
{
    public function create(array $data): PaymentTransaction
    {
        return PaymentTransaction::create($data);
    }

    public function findByOrderId(string $orderId): ?PaymentTransaction
    {
        return PaymentTransaction::where('order_id', $orderId)->first();
    }

    public function updateStatus(PaymentTransaction $transaction, string $status, ?string $refId = null, ?string $saleRefId = null): void
    {
        $transaction->update([
            'status' => $status,
            'ref_id' => $refId,
            'sale_reference_id' => $saleRefId,
        ]);
    }
}
