<?php

namespace App\Repositories\PercentOrderBranch;

use App\Models\PercentOrderBranch;
use App\Repositories\BaseRepository\BaseRepository;


class PercentOrderBranchRepository extends BaseRepository implements RepositoryInterface
{

    public function __construct(PercentOrderBranch $model)
    {
        parent::__construct($model);
    }

    public function store($data)
    {
        return PercentOrderBranch::create($data);
    }

    public function update($id, $data)
    {
        $percentOrderBranch = PercentOrderBranch::where('branch_id',$id)->first();
        if ($percentOrderBranch) {
            $percentOrderBranch->update($data);
            return $percentOrderBranch;
        }

        return null;
    }

    public function find($id)
    {
        return PercentOrderBranch::where('branch_id',$id)->first();
    }

    public function delete($id)
    {
        $percentOrderBranch = PercentOrderBranch::find($id);

        if ($percentOrderBranch) {
            $percentOrderBranch->delete();
            return true;
        }

        return false;
    }
}
