<?php

namespace App\Repositories\PopupAlarm;

use App\Models\PopupAlarm;
use App\Repositories\PopupAlarm\RepositoryInterface;

class PopupAlarmRepository implements RepositoryInterface
{
    protected $repository;

    public function __construct(EloquentRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * ایجاد آلارم جدید
     */
    public function create(array $data)
    {
        return $this->repository->create($data);
    }

    /**
     * دریافت آلارم‌های فعال رستوران
     */
    public function getActiveAlarmsForBranch($branchId)
    {
        return $this->repository->getActiveAlarmsForBranch($branchId);
    }

    /**
     * دریافت آلارم‌های فعال که کاربر ندیده
     */
    public function getUnseenActiveAlarmsForUser($userId, $branchId = null)
    {
        return $this->repository->getUnseenActiveAlarmsForUser($userId, $branchId);
    }

    /**
     * ثبت مشاهده آلارم توسط کاربر
     */
    public function markAsViewed($alarmId, $userId)
    {
        return $this->repository->markAsViewed($alarmId, $userId);
    }

    /**
     * بررسی اینکه کاربر آلارم را دیده یا نه
     */
    public function hasUserSeenAlarm($alarmId, $userId)
    {
        return $this->repository->hasUserSeenAlarm($alarmId, $userId);
    }

    /**
     * دریافت لیست آلارم‌های رستوران
     */
    public function getBranchAlarms($branchId, $perPage = 15)
    {
        return $this->repository->getBranchAlarms($branchId, $perPage);
    }

    /**
     * به‌روزرسانی آلارم
     */
    public function update($id, array $data)
    {
        return $this->repository->update($id, $data);
    }

    /**
     * حذف آلارم
     */
    public function delete($id)
    {
        return $this->repository->delete($id);
    }

    /**
     * دریافت آمار مشاهده آلارم
     */
    public function getAlarmViewStats($alarmId)
    {
        return $this->repository->getAlarmViewStats($alarmId);
    }

    public function getAlarmById($id)
    {
        return $this->repository->getAlarmById($id);
    }
}
