<?php

namespace App\Repositories\PopupAlarm;

interface RepositoryInterface
{
    /**
     * ایجاد آلارم جدید
     */
    public function create(array $data);

    /**
     * دریافت آلارم‌های فعال رستوران
     */
    public function getActiveAlarmsForBranch($branchId);

    /**
     * دریافت آلارم‌های فعال که کاربر ندیده
     */
    public function getUnseenActiveAlarmsForUser($userId, $branchId = null);

    /**
     * ثبت مشاهده آلارم توسط کاربر
     */
    public function markAsViewed($alarmId, $userId);

    /**
     * بررسی اینکه کاربر آلارم را دیده یا نه
     */
    public function hasUserSeenAlarm($alarmId, $userId);

    /**
     * دریافت لیست آلارم‌های رستوران
     */
    public function getBranchAlarms($branchId, $perPage = 15);

    /**
     * به‌روزرسانی آلارم
     */
    public function update($id, array $data);

    /**
     * حذف آلارم
     */
    public function delete($id);

    /**
     * دریافت آمار مشاهده آلارم
     */
    public function getAlarmViewStats($alarmId);

    public function getAlarmById($id);
}
