<?php

namespace App\Repositories\PreparationTime;

use App\Models\PreparationTime;
use App\Repositories\BaseRepository\BaseRepository;

class PreparationTimeRepository extends BaseRepository implements RepositoryInterface
{
    public function __construct(PreparationTime $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [])
    {
        try {
            return $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
            })->get();
        } catch (\Exception $e) {
            handelError('error', $e->getMessage());
            return null;
        }
    }
}
