<?php

namespace App\Repositories\Print;

use App\Models\Order;
use App\Models\PrintJob;
use App\Models\PrinterDevice;
use Illuminate\Support\Collection;

interface PrintingRepositoryInterface
{
    /** پرینترهای فعال و مجاز برای این سفارش (با رعایت order_filters و بازه‌های زمانی) */
    public function eligiblePrintersForOrder(Order $order): Collection;

    /** آیا این آیتم باید روی این پرینتر چاپ شود؟ بر اساس item_filters */
    public function shouldPrintItem(PrinterDevice $printer, $item): bool;

    /** مپ کردن آیتم‌های سفارش به هر پرینتر */
    public function mapOrderItemsToPrinters(Order $order): array; // [printer_id => [items...]]

    /** ساخت جاب‌های چاپ برای هر پرینتر (اختیاری: ذخیره مسیر فایل/پی‌لود) */
    public function createJobsForOrder(Order $order, array $map, ?string $payloadPath = null): Collection;

    /** آپدیت وضعیت جاب و ثبت خطا */
    public function markJob(PrintJob $job, string $status, ?string $error = null): void;
}
