<?php

namespace App\Repositories\ProductDefault;

use App\Models\ProductDefault;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\ExportImport\ExportImportRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(ProductDefault $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
                if (isset($filter['category_id']) && !empty($filter['category_id'])) {
                    $categoryChild = app(CategoryRepository::class)->getAllChildArray($filter['category_id']);
                    $q->whereHas('category', function ($query) use ($categoryChild) {
                        $query->whereIn('id', $categoryChild);
                    });
                }

                if (isset($filter['status']) && !empty($filter['status'])) {
                    $q->where('status', $filter['status']);
                }

            })->with('category');

            if (isset($filter['export']) and $filter['export'] == true) {
                $export = clone $data;
                app(ExportImportRepository::class)->createExcelFileProducts($export->get()->toArray());
            }

            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }



    public function search($filter, $paginate = false, $selects = null)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
            })->with('branch:id,title', 'varieties');
            if ($selects != null)
                $data->select($selects);
            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            return null;
        }
    }


    public function storeP($data)
    {
        try {
            $n = new ProductDefault();
            $n->title = $data['title'];
            $n->category_id = $data['category_id'];
            $n->image = $data['image'];
            $n->description = $data['description'];
            $n->save();
            return $n;
        } catch (\Exception $e) {
            return null;
        }
    }


    public function calculatePercentage($part, $whole)
    {
        try {
            if ($whole != 0 and $part != 0)
                return ($part / $whole) * 100;
            return 0;
        } catch (\Exception $e) {
            return 0;
        }
    }

}
