<?php

namespace App\Repositories\SMS;

use Illuminate\Support\Facades\Log;
use Throwable;

class ChainSMSRepository implements SMSRepositoryInterface
{
    /** @var SMSRepositoryInterface[] */
    protected array $providers;

    public function __construct(array $providers)
    {
        // فقط ریپوهای معتبر رو نگه دار
        $this->providers = array_values(array_filter(
            $providers,
            fn ($p) => $p instanceof SMSRepositoryInterface
        ));
    }

    private function callAcross(string $method, array $args)
    {
        $errors = [];

        foreach ($this->providers as $provider) {
            $name = class_basename($provider);

            try {
                $result = $provider->{$method}(...$args);

                // ساده: هر نتیجه truthy موفق محسوب می‌شود
                // (اگر ریپازیتوری‌هات آرایه برمی‌گردونن، می‌تونی داخلش 'status' یا 'ok' رو چک کنی)
                // if ($this->isSuccess($result)) {
                //     return $result;
                // }
                if ($result['status'] == 200) {
                    return $result;
                }

                $errors[] = "{$name}: non-success result";
                Log::warning("SMS {$method} via {$name} returned non-success.", ['result' => $result]);
            } catch (Throwable $e) {
                $errors[] = "{$name}: ".$e->getMessage();
                Log::warning("SMS {$method} via {$name} failed.", [
                    'provider' => $name,
                    'error'    => $e->getMessage(),
                ]);
            }
        }

        // اگر همه شکست خوردن، یک خطای ساده پرت کن
        throw new \RuntimeException('All SMS providers failed for '.$method.' => '.implode(' | ', $errors));
    }

    private function isSuccess($result): bool
    {
        if ($result === true) return true;
        if ($result === null) return true; // خیلی از متدها چیزی برنمی‌گردونن
        if (is_array($result)) {
            // حالت‌های رایج
            if (isset($result['ok']) && $result['ok'] === true) return true;
            if (isset($result['status']) && in_array(strtolower((string)$result['status']), ['ok','success','sent'], true)) return true;
            if (isset($result['code']) && ((int)$result['code'] === 200)) return true;
        }
        return (bool)$result;
    }

    // از اینجا به بعد تمام متدهای اینترفیس به شکل ساده به callAcross پاس می‌شن:

    public function send($body, $idPattern, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSSendCode($code, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSToUserAwaitingRestaurantApproval($orderId, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSOrderDeliveredWithCashBack($name, $amount, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSOrderStatus($orderId, $textStatus, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSToDriver($orderId, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSNewOrder($orderId, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function OpenOrderReminder($orderId, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSCashBack($mobile, $restaurantName, $priceCashBack, $date)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSOrderDelayApproval($orderId, $customerName, $orderAmount, $restaurantName, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSOrderDelayDelivery($orderId, $customerName, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSInactiveProducts($inactiveCount, $restaurantName, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSTicketAnswered($ticketId, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSWaitingAnswer($ticketId, $mobiles)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }

    public function sendSMSWelcomeCoupon($couponCode, $mobile)
    {
        return $this->callAcross(__FUNCTION__, func_get_args());
    }
}
