<?php

namespace App\Repositories\SMS;
use Illuminate\Support\Facades\Log;

class FarazSmsRepository implements SMSRepositoryInterface
{
    public function send($body, $idPattern, $mobiles)
    {
        $username = env('FARAZSMS_USERNAME');
        $password = env('FARAZSMS_PASSWORD');

        if (env('FARAZSMS_FROM') != null and env('FARAZSMS_FROM') != "")
            $from = env('FARAZSMS_FROM');
        else
            $from = "3000505";

        $url = "https://ippanel.com/patterns/pattern?username=" . $username . "&password=" . urlencode($password) . "&from=" . $from . "&to=" . json_encode($mobiles) .
            "&input_data=" . urlencode(json_encode($body)) . "&pattern_code=$idPattern";

        $handler = curl_init($url);
        curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($handler, CURLOPT_POSTFIELDS, $body);
        curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($handler);

        return ['status' => 200, 'message' => 'ارسال موفق بود ', 'data' => ''];
    }

    public function sendSMSSendCode($code, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_CODE');
        return $this->send(['code' => $code], $idPattern, [$mobile]);
    }

    public function sendSMSToUserAwaitingRestaurantApproval($orderId, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TO_USER_AWAITING_RESTAURANT_APPROVAL');
        return $this->send(['code' => $orderId], $idPattern, [$mobile]);
    }

    public function sendSMSOrderStatus($orderId, $textStatus, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TO_USER_ORDER_STATUS');
        return $this->send(['code' => $orderId, 'status' => $textStatus], $idPattern, [$mobile]);
    }

    public function sendSMSOrderDeliveredWithCashBack($name, $amount, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TO_USER_ORDER_DELIVERED_CASHBACK');
        return $this->send(['name' => $name, 'amount' => $amount], $idPattern, [$mobile]);
    }

    public function sendSMSToDriver($orderId, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TO_DRIVER_NEW_ORDER');
        return $this->send(['code' => $orderId], $idPattern, [$mobile]);
    }

    public function sendSMSNewOrder($orderId, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TO_RESTAURANT_NEW_ORDER');
        return $this->send(['code' => $orderId], $idPattern, [$mobile]);
    }

    public function sendSMSTicketAnswered($ticketId, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TICKETING_ANSWERED');
        return $this->send(['code' => $ticketId], $idPattern, [$mobile]);
    }

    public function sendSMSWaitingAnswer($ticketId, $mobiles)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_TICKETING_WAITING_ANSWER');
        return $this->send([$ticketId], $idPattern, $mobiles);
    }

    public function OpenOrderReminder($orderId, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_Open_Order_Reminder');
        return $this->send(['orderId' => $orderId], $idPattern, $mobile);
    }
    public function sendSMSCashBack($mobile, $restaurantName, $priceCashBack, $date)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_CASH_BACK');
        return $this->send(['restaurantName' => $restaurantName, 'priceCashBack' => $priceCashBack, 'date' => $date], $idPattern, $mobile);
    }

    public function sendSMSOrderDelayApproval($orderId, $customerName, $orderAmount, $restaurantName, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_ORDER_DELAY_APPROVAL');
        return $this->send(['orderId' => $orderId, 'customerName' => $customerName, 'orderAmount' => $orderAmount, 'restaurantName' => $restaurantName], $idPattern, [$mobile]);
    }

    public function sendSMSOrderDelayDelivery($orderId, $customerName, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_ORDER_DELAY_DELIVERY');
        return $this->send(['orderId' => $orderId, 'customerName' => $customerName], $idPattern, [$mobile]);
    }

    public function sendSMSInactiveProducts($inactiveCount, $restaurantName, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_INACTIVE_PRODUCTS');
        return $this->send(['inactiveCount' => $inactiveCount, 'restaurantName' => $restaurantName], $idPattern, [$mobile]);
    }

    public function sendSMSWelcomeCoupon($couponCode, $mobile)
    {
        $idPattern = env('FARAZSMS_SEND_SMS_WELCOME_COUPON');
        return $this->send(['couponCode' => $couponCode], $idPattern, [$mobile]);
    }
}
